<?php
/**
 * @package etrade
 */

if( !class_exists('etrade_Info_Widget') ){
    class etrade_Info_Widget extends WP_Widget{
    	/**
         * Register widget with WordPress.
         */
        function __construct(){

            $widget_options = array(
                'description'                   => esc_html__('etrade: Info here', 'etrade-elements'),
                'customize_selective_refresh'   => true,
            );

            parent:: __construct('etrade_Info_Widget', esc_html__( 'etrade: About', 'etrade-elements'), $widget_options );

        }
        /**
         * Front-end display of widget.
         *
         * @see WP_Widget::widget()
         *
         * @param array $args     Widget arguments.
         * @param array $instance Saved values from database.
         */
        public function widget( $args, $instance ){
        	echo wp_kses_post( $args['before_widget'] );
        	if ( ! empty( $instance['title'] ) ) {
        		echo wp_kses_post( $args['before_title'] ) . apply_filters( 'widget_title', esc_html( $instance['title'] ) ) . wp_kses_post( $args['after_title'] );
        	}
        	$logo = isset( $instance['logo'] ) ? $instance['logo'] : '';
            $logo2 = isset( $instance['logo2'] ) ? $instance['logo2'] : '';
        	$phone = isset( $instance['phone'] ) ? $instance['phone'] : '';
            $email = isset( $instance['email'] ) ? $instance['email'] : '';
            $content = isset( $instance['content'] ) ? $instance['content'] : ''; 
        	?>

            <?php
                if ( !empty($logo) ) {
                    ?>
                    <div class="logo footer-logo-light mb--30"><a href="<?php echo esc_url(home_url('/')); ?>" class="aw-foo-logo">
                        <img src="<?php echo esc_url( $logo ) ; ?>" alt="<?php echo esc_attr('Logo'); ?>"></a>
                    </div> 
               <?php  } ?>
                <?php
                if ( !empty($logo) ) {
                    ?>
                    <div class="logo footer-logo-dark mb--30">
                        <a href="<?php echo esc_url(home_url('/')); ?>" class="aw-foo-logo">
                             <img src="<?php echo esc_url( $logo2 ) ; ?>" alt="<?php echo esc_attr('dark logo'); ?>">
                        </a>
                    </div> 
               <?php  }  ?>  
            <div class="inner">
                <?php if ( !empty($content) ): ?>
                    <div class="address">
                        <?php echo wpautop( $content ); ?>
                    </div>
                <?php endif ?> 

                <ul class="support-list-item"> 
                     <?php if ( !empty($email) ): ?>
                        <li><a href="mailto:<?php echo wpautop( $email ); ?>"><i class="fal fa-envelope-open"></i> <?php echo wpautop( $email ); ?></a></li>
                     <?php endif ?>  
                    <?php if ( !empty($phone) ): ?>
                        <li><a href="tel:<?php echo wpautop( $phone ); ?>"><i class="fal fa-phone-alt"></i> <?php echo wpautop( $phone ); ?></a></li>
                    <?php endif ?>  
                </ul>
            </div> 

        	<?php
        	echo wp_kses_post( $args['after_widget'] );
        }

        /**
         * Sanitize widget form values as they are saved.
         *
         * @see WP_Widget::update()
         *
         * @param array $new_instance Values just sent to be saved.
         * @param array $old_instance Previously saved values from database.
         *
         * @return array Updated safe values to be saved.
         */
        public function update( $new_instance, $old_instance ){
        	$instance               = array();
        	$instance['title']      = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
        	$instance['logo'] 	    = ( ! empty( $new_instance['logo'] ) ) ? strip_tags ( $new_instance['logo'] ) : '';
            $instance['logo2']      = ( ! empty( $new_instance['logo2'] ) ) ? strip_tags ( $new_instance['logo2'] ) : '';
        	$instance['content']    = ( ! empty( $new_instance['content'] ) ) ? strip_tags ( $new_instance['content'] ) : '';
            $instance['phone']      = ( ! empty( $new_instance['phone'] ) ) ? strip_tags ( $new_instance['phone'] ) : '';
            $instance['email']      = ( ! empty( $new_instance['email'] ) ) ? strip_tags ( $new_instance['email'] ) : '';
        	 
        	
            if ( current_user_can( 'unfiltered_html' ) ) {
			        $instance['content'] = $new_instance['content'];
			} else {
			        $instance['content'] = wp_kses_post( $new_instance['content'] );
			}
        	return $instance;
        }

        /**
         * Back-end widget form.
         *
         * @see WP_Widget::form()
         *
         * @param array $instance Previously saved values from database.
         */
        public function form($instance){ 
        	$title      = !empty( $instance['title'] ) ? $instance['title'] : '';
        	$logo       = !empty( $instance['logo'] ) ? $instance['logo'] : '';
            $logo2      = !empty( $instance['logo2'] ) ? $instance['logo2'] : '';
        	$content    = !empty( $instance['content'] ) ? $instance['content'] : ''; 
            $phone      = !empty( $instance['phone'] ) ? $instance['phone'] : ''; 
            $email      = !empty( $instance['email'] ) ? $instance['email'] : ''; 
        	 
        	?>
			<p>
				<label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php echo esc_html__('Title:' ,'etrade-elements') ?></label>
				<input id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" class="widefat" value="<?php echo esc_textarea( $title ); ?>">
			</p>
			<div class="image_box_wrap" style="margin:20px 0 15px 0; width: 100%;">
                <label for="<?php echo esc_attr($this->get_field_id('logo')); ?>"><?php echo esc_html__('Light Logo:' ,'etrade-elements') ?></label>
				<button class="button button-primary author_info_image">
					<?php esc_html_e('Upload Logo', 'etrade-elements'); ?>
				</button>
				<div class="image_box widefat">
					<img src="<?php if( !empty($logo)){echo esc_html($logo);} ?>" style="margin:15px 0 0 0;padding:0;max-width: 100%;display:inline-block; height: auto;" alt="<?php echo esc_attr(''); ?>" />
				</div>
				<input type="text" class="widefat image_link" name="<?php echo esc_attr($this->get_field_name('logo')); ?>" id="<?php echo esc_attr($this->get_field_id('logo')); ?>" value="<?php echo esc_attr($logo); ?>" style="margin:15px 0 0 0;">
			</div>

            <div class="image_box_wrap" style="margin:20px 0 15px 0; width: 100%;">
                <label for="<?php echo esc_attr($this->get_field_id('logo2')); ?>">
                    <?php echo esc_html__('Dark Logo:' ,'etrade-elements') ?>
                </label>
                <button class="button button-primary author_info_image">
                    <?php esc_html_e('Upload Logo', 'etrade-elements'); ?>
                </button>
                <div class="image_box widefat">
                    <img src="<?php if( !empty($logo2)){echo esc_html($logo2);} ?>" style="margin:15px 0 0 0;padding:0;max-width: 100%;display:inline-block; height: auto;" alt="<?php echo esc_attr(''); ?>" />
                </div>
                <input type="text" class="widefat image_link" name="<?php echo esc_attr($this->get_field_name('logo2')); ?>" id="<?php echo esc_attr($this->get_field_id('logo2')); ?>" value="<?php echo esc_attr($logo2); ?>" style="margin:15px 0 0 0;">
            </div>

            <p>
                <label for="<?php echo esc_attr($this->get_field_id('email')); ?>"><?php echo esc_html__('Email:' ,'etrade-elements') ?></label>
                <input id="<?php echo esc_attr($this->get_field_id('email')); ?>" name="<?php echo esc_attr($this->get_field_name('email')); ?>" type="text" class="widefat" value="<?php echo esc_textarea( $email ); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('phone')); ?>"><?php echo esc_html__('Phone:' ,'etrade-elements') ?></label>
                <input id="<?php echo esc_attr($this->get_field_id('phone')); ?>" name="<?php echo esc_attr($this->get_field_name('phone')); ?>" type="text" class="widefat" value="<?php echo esc_textarea( $phone ); ?>">
            </p>
 
			<p>
				<label for="<?php echo esc_attr($this->get_field_id('content')); ?>"><?php echo esc_html__('Content:' ,'etrade-elements') ?></label>
				<textarea  id="<?php echo esc_attr($this->get_field_id('content')); ?>" name="<?php echo esc_attr($this->get_field_name('content')); ?>" rows="7" class="widefat" ><?php echo esc_textarea( $content ); ?></textarea>
			</p>
			 
        	<?php
        }
	}
}
function etrade_Info_Widget(){
    register_widget('etrade_Info_Widget');
}
add_action('widgets_init','etrade_Info_Widget');